#!/usr/bin/perl -w

# script pour ouvrir une occurrence schwa dans Praat
# modification : 13/10/06

use strict;
use File::Basename;

# Variables utilisateur (a modifier)
my $HOME = "/Users/Julien";
my $PFC  = $HOME . "/PFC/Corpus";
my $INIT_SCRIPT   = $HOME . "/.praat-user-startUp";
my $PRAAT_SCRIPT  = "/tmp/schwa.praat";
my $PRAAT_COMMAND = "open /Applications/Praat.app";

# Variables programme
my ($token, $survey, $speaker, $task, $interval, $tier);
my ($wav, $textgrid);
my ($script_content, $init_content);
my @arg;

# rglage des paramtres
$token = $ARGV[0];
$token =~ /^(...)(...)(.)(s|l)-(...)-(..)$/ 
	or die "Mauvais format !\n";
$survey = $1; $speaker = $2; $task = $3; $tier = $4; $interval = $5;

if ($tier =~ /s/) { $tier = 2 }
elsif ($tier =~ /l/) { $tier = 3 }


$textgrid = $survey . $speaker . $task . "g.TextGrid";
$wav = $survey . $speaker . $task . "w.wav";
$textgrid = "$PFC/$survey/$survey$speaker/$textgrid";
$wav = "$PFC/$survey/$survey$speaker/$wav";


# cration du script praat
$script_content = "! Generated by praat_schwa.pl\n\n"
	. "Open long sound file... $wav\n"
	. "Read from file... $textgrid\n\n"
	. "begin = Get starting point... $tier $interval\n"
	. "begin = begin + 0.1\n"
	. "end = Get end point... $tier $interval\n\n";
	
	$wav = basename($wav);
	$wav =~ s/\.wav$//i;
	$textgrid = basename($textgrid);
	$textgrid =~ s/\.TextGrid//i;

	$script_content .= "select LongSound $wav\n"
	. "plus TextGrid $textgrid\n"
	. "Edit\n\n"
	. "editor TextGrid $textgrid\n"
	. "\tSelect next tier\n"
	. "\tZoom... \'begin\' \'end\'\n"
	. "\tMove cursor to... \'begin\'\n"
	. "\tMove cursor to begin of selection\n"
	#. "\tFind... $token\n"
	. "endeditor\n\n";


# cration du script d'initialisation
$init_content = "! Generated by codingPraat.pl\n\n"
	. "file\$ = \"$PRAAT_SCRIPT\"\n\n"
	. "if fileReadable (file\$)\n"
	. "\tRun script... 'file\$'\n"
	. "endif\n\n";


if (not -f $INIT_SCRIPT)
{
	# criture des fichiers 
	open (INIT, ">$INIT_SCRIPT") 
		or die "Impossible d'ecrire $INIT_SCRIPT : $!\n";

	print INIT $init_content;

	close INIT;
}

open (SCRIPT, ">$PRAAT_SCRIPT") 
	or die "Impossible d'ecrire $PRAAT_SCRIPT : $!\n";
	
print SCRIPT $script_content;


close SCRIPT;


# lancement de Praat
@arg = ($PRAAT_COMMAND);
system @arg;
