#!/usr/bin/perl -w

# script pour jouer un schwa dans Praat sans l'ouvrir
# modification : 30/09/06

use strict;
use File::Basename;

# Variables utilisateur (a modifier)
my $HOME = "/Users/Julien";
my $PFC  = $HOME . "/PFC/Corpus";
my $INIT_SCRIPT   = $HOME . "/.praat-user-startUp";
my $PRAAT_SCRIPT  = "/tmp/play_schwa.praat";
my $PRAAT_PATH = "/Applications/Praat.app/Contents/MacOS/Praat";

# Variables programme
my ($token, $survey, $speaker, $task, $interval, $tier);
my ($wav, $textgrid);
my ($script_content, $init_content);
my @args;

# rglage des paramtres
$token = $ARGV[0];
$token =~ /^(...)(...)(.)(s|l)-(...)-(..)$/ 
	or die "Mauvais format !\n";
$survey = $1; $speaker = $2; $task = $3; $tier = $4; $interval = $5;

if ($tier =~ /s/) { $tier = 2 }
elsif ($tier =~ /l/) { $tier = 3 }


$textgrid = $survey . $speaker . $task . "g.TextGrid";
$wav = $survey . $speaker . $task . "w.wav";
$textgrid = "$PFC/$survey/$survey$speaker/$textgrid";
$wav = "$PFC/$survey/$survey$speaker/$wav";


# cration du script praat
$script_content = "! Generated by praat_schwa.pl\n\n"
	. "Open long sound file... $wav\n"
	. "Read from file... $textgrid\n\n"
	. "begin = Get starting point... $tier $interval\n"
	. "end = Get end point... $tier $interval\n\n";
	
	$wav = basename($wav);
	$wav =~ s/\.wav$//i;
	$textgrid = basename($textgrid);
	$textgrid =~ s/\.TextGrid//i;

	$script_content .= "select LongSound $wav\n"
	. "Play part... 'begin' 'end'\n\n";
	

# cration du script d'initialisation
# $init_content = "Run script... $PRAAT_SCRIPT\n";
# 
# 
# criture des fichiers 
# open (INIT, ">$INIT_SCRIPT") 
# 	or die "Impossible d'ecrire $INIT_SCRIPT : $!\n";

open (SCRIPT, ">$PRAAT_SCRIPT") 
	or die "Impossible d'ecrire $PRAAT_SCRIPT : $!\n";
	
##print INIT $init_content;
print SCRIPT $script_content;

#close INIT;
close SCRIPT;


# lancement de Praat
@args = ($PRAAT_PATH, $PRAAT_SCRIPT);
system @args;
