#!/usr/bin/env python

# code source these Eychenne (2006). Domaine public. 
# Initialement developpe sur Mac OS X 10.4

import sqlite3 as sqlite
from decimal import Decimal
import csv, sys
import os



db = 'SchwaPhD.db'
table = 'Schwa64a'
mydir = '/Users/Julien/Programmation/BaseSchwa'

if len(sys.argv) > 1:
	table = sys.argv[1]

# cree la table
connection = sqlite.connect( os.path.join(mydir, db) )
cursor = connection.cursor()

# early versions of sqlite don't have "if exists"
try:
	cursor.execute('DROP TABLE %s;' % table) 
except:
	pass


cursor.execute('CREATE TABLE %s (Occurrence, Enquete, Locuteur, Tache, Type, Graphie, Pos1, Pos2, Pos3, Pos4, ContGauche, Token, ContDroit, Phonet, CatPrec, Cat, CatSuiv, CGI, FrontAv, CGD, Schwa, FrontAp, CDD, CDI);' % table)

# importe le fichier 
file = os.path.join(mydir, 'schwa-%s.csv' % table[5:])
cr = csv.reader(open(file, "rb"), delimiter='\t')

cr.next() # ignore l'entete

for line in cr:
	insert = 'INSERT INTO %s VALUES("%s");' % (table, '","'.join(line))
	cursor.execute(insert)


connection.commit()

# 
# cursor.execute("SELECT * FROM " + table+ " where Locuteur='64ama3' AND Pos1='1';")
# 
# 
# i = 0
# for row in cursor.fetchall(): 
# 	i += 1
# 	#print row
# print i



###
### REQUETES SQL POUR PFC
###

def calcPercent(arr):
	total = 0
	for i in arr: 
		total += i
	if total == 0:
		return (0, 0)
	else:
		perc =  float(arr[1]) / float(total) #* 100.0
	return (perc, total)
	#pourc = round(pourc,1)


basque = [
	'64ajm1', #1910
	'64ama4', #1928 
	'64ama1', #1936
	'64aji1', #1941
	'64ama3', #1963
	'64ama2', #1964
	'64ajc1', #1964
	'64ast1', #1967
	'64asl1', #1967
	'64api1', #1971
	'64aab1', #1972
	'64apl1' #1976 
	]
vendee = [
	'85ajg1 87 M',
	'85amg1 62 F',
	'85asl1 59 M',
	'85amm1 56 F', 
	'85ajf1 45 M',
	'85alt1 39 M',
	'85agm1 22 M',
	'85apr1 20 F'
]

canada = [
	'cappm1 82 H',
	'capca1 80 F',
	'capmg1 75 F',	
	'capdl1 72 H',
	'capal1 68 F',
	'caplm1 56 F',
	'capag2 51 H',
	'capag3 45 F',
	'caprl1 45 F',
	'capca2 19 F',
	'capvg1 17 F',
	'caplg1 14 H'
]


languedoc = []

corpus = {'11a' : languedoc, '64a' : basque, '85a' : vendee, 'cap' : canada}

locuteurs = corpus['cap']

requests = [
	## FIN DE POLYSYLLABE
	
	["Contexte prepausal <Ce> (eX4X3/4)",
	 "Pos2= '4'  AND (Pos4 = '3' OR Pos4 = '4') AND Graphie='e'"],

	["Contexte prepausal <C> (xX4X3/4)",
	 "Pos2= '4'  AND (Pos4 = '3' OR Pos4 = '4') AND Graphie='x'"],

	["Contexte prepausal <VCe> (eX413/4)",
	 "Pos2= '4' AND Pos3 = '1' AND (Pos4 = '3' OR Pos4 = '4') AND Graphie='e'"],

	["Contexte prepausal <VC> (xX413/4)",
	 "Pos2= '4'  AND Pos3 = '1' AND (Pos4 = '3' OR Pos4 = '4') AND Graphie='x'"],

	["Contexte prepausal <CCe> (eX423/4)",
	 "Pos2= '4' AND Pos3 = '2' AND (Pos4 = '3' OR Pos4 = '4') AND Graphie='e'"],

	["Contexte prepausal <CC> (xX423/4)",
	 "Pos2= '4'  AND Pos3 = '2' AND (Pos4 = '3' OR Pos4 = '4') AND Graphie='x'"],



	["Fin de poly <XCe#X> (eX4XX) tout",
	 "Pos2= '4' AND Pos4 != '1'  AND Graphie='e'"],

	["Fin de poly <XC#X> (xX4XX) tout",
	 "Pos2= '4' AND Pos4 != '1'  AND Graphie='x'"],



	["Fin de poly <Ce> (eX4X2) CONV",
	 "Pos2= '4' AND Pos4= '2'  AND Graphie='e' and Tache !='TEXTE'"],

	["Fin de poly <Ce> (eX4X2) TEXTE",
	 "Pos2= '4' AND Pos4= '2'  AND Graphie='e' and Tache ='TEXTE'"],

	["Fin de poly <C> (xX4X2) CONV",
	 "Pos2= '4' AND Pos4= '2'  AND Graphie='x' and Tache !='TEXTE'"],

	["Fin de poly <C> (xX4X2) TEXTE",
	 "Pos2= '4' AND Pos4= '2'  AND Graphie='x' and Tache ='TEXTE'"],


	["Fin de poly <VCe#C> (eX412) CONV",
	 "Pos2= '4' AND Pos3= '1' AND Pos4= '2'  AND Graphie='e' and Tache !='TEXTE' AND Type !='elle'"],

	["Fin de poly <VCe#C> (eX412) TEXTE",
	 "Pos2= '4' AND Pos3= '1' AND Pos4= '2'  AND Graphie='e' and Tache ='TEXTE' AND Type !='elle'"],

	["Fin de poly <VC#C> (xX412) CONV",
	 "Pos2= '4' AND Pos3= '1' AND Pos4= '2'  AND Graphie='x' and Tache !='TEXTE' AND Type !='elle'"],

	["Fin de poly <VC#C> (xX412) TEXTE",
	 "Pos2= '4'  AND Pos3= '1' AND Pos4= '2'  AND Graphie='x' and Tache ='TEXTE' AND Type !='elle'"],


	["Amas consonantiques <CCe#C> (eX412)",
	 "Pos2= '4'  AND Pos3= '2' AND Pos4= '2'  AND Graphie='e'"],	
	["Amas consonantiques <CC#C> (xX412)",
	 "Pos2= '4'  AND Pos3= '2' AND Pos4= '2'  AND Graphie='x'"],	


	["Simplifications consonantiques <C(C)e#C> (eX452)",
	 "Pos2= '4'  AND Pos3= '5'  AND Pos4= '2' AND Graphie='e'"],
	
	["Simplifications consonantiques <C(C)#C> (xX452)",
	 "Pos2= '4'  AND Pos3= '5' AND Pos4= '2' AND Graphie='x'"],	

	["Simplifications consonantiques pause <C(C)e##> (eX453/4)",
	 "Pos2= '4'  AND Pos3= '5' AND (Pos4= '3' OR Pos4 = '4')  AND Graphie='e'"],
	
	["Simplifications consonantiques pause <C(C)##> (xX453/4)",
	 "Pos2= '4'  AND Pos3= '5' AND (Pos4= '3' OR Pos4 = '4') AND Graphie='x'"],

	## POSITION INTERNE
	["Interne <VCeC> (eX3X2) tout",
	 "Pos2= '3'  AND Pos4= '2' AND Type != 'parce'"],


	["Interne <VCeC> (eX312) tout",
	 "Pos2= '3'  AND Pos3= '1' AND Pos4= '2' AND Type != 'parce'"],
	 
	["Interne <CCeC> (eX322) tout",
	 "Pos2= '3'  AND Pos3= '2' AND Pos4= '2' AND Type != 'parce'"],	


	["Interne <VCeC> (eX312) conv",
	 "Pos2= '3'  AND Pos3= '1' AND Pos4= '2' AND Tache != 'TEXTE' AND Type != 'parce'"],

	["Interne <VCeC> (eX312) texte",
	 "Pos2= '3'  AND Pos3= '1' AND Pos4= '2' AND Tache = 'TEXTE' AND Type != 'parce'"],


	["Interne <CCeC> (eX322) conv",
	 "Pos2= '3'  AND Pos3= '2' AND Pos4= '2' AND Tache != 'TEXTE' AND Type != 'parce'"],

	["Interne <CCeC> (eX322) texte",
	 "Pos2= '3'  AND Pos3= '2' AND Pos4= '2' AND Tache = 'TEXTE' AND Type != 'parce'"],


	## DEBUT DE POLYSYLLABE
	["Debut <X#CeC> (eX2X2) tout",
	 "Pos2= '2'  AND Pos4= '2'"],	
	
	["debut <X#CeC> (eX2X2) CONV",
	 "Pos2= '2' AND Pos4= '2' AND Tache != 'TEXTE'"],

	["debut <X#CeC> (eX2X2) TEXTE",
	 "Pos2= '2' AND Pos4= '2' AND Tache = 'TEXTE'"],


	["debut prevocalique <V#CeC> (eX212) tout",
	 "Pos2= '2'  AND Pos3= '1' AND Pos4= '2'"],
	
	["debut preconsonantique <C#CeC> (eX222) tout",
	 "Pos2= '2'  AND Pos3= '2' AND Pos4= '2'"],	

	["debut de groupe <##CeC> (eX232) tout",
	 "Pos2= '2'  AND Pos3= '3' AND Pos4= '2'"],
	 
	 
	["debut prevocalique <V#CeC> (eX212) conv",
	 "Pos2= '2'  AND Pos3= '1' AND Pos4= '2' AND Tache != 'TEXTE'"],
	 
	["debut prevocalique <V#CeC> (eX212) texte",
	 "Pos2= '2'  AND Pos3= '1' AND Pos4= '2' AND Tache = 'TEXTE'"],
	 
	["debut preconsonantique <C#CeC> (eX222) conv",
	 "Pos2= '2'  AND Pos3= '2' AND Pos4= '2' AND Tache != 'TEXTE'"],	

	["debut preconsonantique <C#CeC> (eX222) texte",
	 "Pos2= '2'  AND Pos3= '2' AND Pos4= '2' AND Tache = 'TEXTE'"],	

	## MONOSYLLABES
	["Debut <X#Ce#C> (eX1X2) tout",
	 "Pos2= '2'  AND Pos4= '2'"],		
	
	["Monosyllabes <#Ce#C> (eX1X2) CONV",
	 "Pos2= '1' AND Pos4= '2' AND Tache != 'TEXTE'"],

	["Monosyllabes <#Ce#C> (eX1X2) TEXTE",
	 "Pos2= '1' AND Pos4= '2' AND Tache = 'TEXTE'"],


	["Monosyllabes <V#Ce#C> (eX112) tout",
	 "Pos2= '1' AND Pos3= '1' AND Pos4= '2'"],

	["Monosyllabes <C#Ce#C> (eX122) tout",
	 "Pos2= '1' AND Pos3= '2' AND Pos4= '2'"],

	["Monosyllabes <C#Ce#C> (eX132) tout",
	 "Pos2= '1' AND Pos3= '3' AND Pos4= '2'"],

	 
	["Monosyllabes <V#Ce#C> (eX112) conv",
	 "Pos2= '1' AND Pos3= '1' AND Pos4= '2'  AND Tache != 'TEXTE'"],
	 
	["Monosyllabes <V#Ce#C> (eX112) texte",
	 "Pos2= '1' AND Pos3= '1' AND Pos4= '2'  AND Tache = 'TEXTE'"],

	["Monosyllabes <C#Ce#C> (eX122) conv",
	 "Pos2= '1' AND Pos3= '2' AND Pos4= '2'  AND Tache != 'TEXTE'"],
	 
	["Monosyllabes <C#Ce#C> (eX122) texte",
	 "Pos2= '1' AND Pos3= '2' AND Pos4= '2'  AND Tache = 'TEXTE'"],

	["Monosyllabes <##Ce#C> (eX132) conv",
	 "Pos2= '1' AND Pos3= '3' AND Pos4= '2'  AND Tache != 'TEXTE'"],
	 
	["Monosyllabes <##Ce#C> (eX132) texte",
	 "Pos2= '1' AND Pos3= '3' AND Pos4= '2'  AND Tache = 'TEXTE'"]
]




# execute SQL select

outfile = open( os.path.join(mydir, table + '-res.txt'), 'w')

for rq in requests:
	requestHeader = rq[0]
	requestString = rq[1]

	res = {}
	ens = [0,0,0]

	# write header for each array
	outfile.write('\n'+ requestHeader +'\n\n')
	outfile.write( '\tabsent\tpresent\tincertain\ttotal\t\\% realis.\n' )
	
	
	for loc in locuteurs:
		res[loc] = []
		Qloc = "Locuteur = '%s' AND " % loc[:6]
	
		for pos in range(3):
			selectString = "SELECT * FROM %s WHERE " % table
			Qcoding = "Pos1= '" + str(pos) + "' AND " + requestString

			query = selectString + Qloc + Qcoding +";"
			#print query

			cursor.execute(query)
			
			nbr = 0
			for row in cursor.fetchall(): 
				nbr += 1
			
			res[loc].append(nbr)
	
			# calcule pour l'ensemble
			ens[pos] += nbr
	
		# calcule % pour chaque loc
		(pourc, total) = calcPercent(res[loc])
		
		outfile.write( "%s\t%d\t%d\t%d\t%d\t%s" % (loc[3:].upper(), res[loc][0],res[loc][1],res[loc][2],total,str(pourc).replace('.',',')) + '\n')
	
	# imprime total
	(pourc, total) = calcPercent(ens)
	outfile.write( "%s\t%d\t%d\t%d\t%d\t%s" % ("total", ens[0],ens[1],ens[2],total,str(pourc).replace('.',',')) + '\n')
	outfile.write("\n\n")

